package uts.sdk.modules.jpayApm

import android.content.Intent
import android.graphics.Color
import android.net.Uri
import androidx.browser.customtabs.CustomTabsIntent
import io.dcloud.uts.console
import io.dcloud.uts.UTSAndroid
import io.dcloud.uts.UTSJSONObject

class JPayAPM {

    private var payStatus: Int = 0 // 0: unpaid, 1: succeeded, 2: failed
    private var payCallback: ((UTSJSONObject) -> Unit)? = null

	/**
	 * Execute payment request
	 * @param payMethod Payment method identifier (currently supports googlepay)
	 * @param url Payment URL
	 * @param callback Callback function, parameters are status code, message, and order ID
	 */
	fun exec(payMethod: String, url: String, callback: ((UTSJSONObject) -> Unit)? = null) {
		console.log("exec: payMethod=$payMethod, url=$url")
        this.payStatus = 0
        this.payCallback = callback
		this.payByUrl(url)
	}

    /**
     * Handle payment result
     * @param status Payment status 0: unpaid, 1: succeeded, 2: failed
     * @param message Payment message
     * @param orderId Order ID
     */
    private fun handlePayResult(status: Int, message: String, orderId: String = "") {
        this.payStatus = status
        console.log("Payment result: status=$status, message=$message, orderId=$orderId")

		var obj: UTSJSONObject = object : UTSJSONObject() {
            var status = status
            var message = message
            var orderId = orderId
        }
        this.payCallback?.invoke(obj)
    }

	/**
	 * Use Chrome Custom Tabs to handle payment
	 * @param url Payment URL
	 */
	fun payByUrl(url: String) {
		try {
			// get application context
			val context = UTSAndroid.getAppContext()
			if (context == null) {
				val errorMsg = "Error: Context is null"
				console.log(errorMsg)
				this.handlePayResult(2, errorMsg, "")
				return
			}
			
			// get current activity
			val activity = UTSAndroid.getUniActivity()
			if (activity == null) {
				val errorMsg = "Error: Activity is null"
				console.log(errorMsg)
				this.handlePayResult(2, errorMsg, "")
				return
			}
				
			// check URL format
			val uri = Uri.parse(url)
			if (uri.scheme.isNullOrEmpty() || uri.host.isNullOrEmpty()) {
				val errorMsg = "Error: Invalid URL format ($url)"
				console.log(errorMsg)
				this.handlePayResult(2, errorMsg, "")
				return
			}
			
			val intentBuilder = CustomTabsIntent.Builder()
			val customTabsIntent = intentBuilder.build()
			
			customTabsIntent.launchUrl(activity, uri)
		} catch (e: Exception) {
			val errorMsg = "Google Pay initialization failed: ${e.message ?: "Unknown exception"}"
			console.log(errorMsg)
			e.printStackTrace()
			this.handlePayResult(2, "JPay APM initialization failed", "")
		}
	}
}