<?php
/*
 * Plugin Name: jpay
 * Plugin URI: #
 * Description: jpay
 * Version: v1.0.0
 * Author: 
 * Author URI: #
 * Requires at least: 3.3
 * Tested up to: 3.5.1
 * Text Domain: jpay
 * Domain Path: /lang/
 */
if (preg_match('#' . basename(__FILE__) . '#', $_SERVER['PHP_SELF'])) die('You are not allowed to call this page directly.');

add_action('plugins_loaded', 'jpay_gateway_init');

function jpay_gateway_init()
{
    if (!class_exists('WC_Payment_Gateway')) return;

    load_plugin_textdomain('jpay', false, dirname(plugin_basename(__FILE__)) . '/lang/');
    require_once(plugin_basename('class-wc-jpay.php'));
    add_filter('woocommerce_payment_gateways', 'woocommerce_jpay_add_gateway');
}

/**
 * Add the gateway to WooCommerce
 *
 * @access public
 * @param array $methods
 * @package WooCommerce/Classes/Payment
 * @return array
 */
function woocommerce_jpay_add_gateway($methods)
{
    $methods[] = 'WC_jpay';
    return $methods;
}

?>