<?php
    require(dirname( __FILE__ ).'/wp-load.php');
    get_header();
    
    $paymentMethod='';
    $paymentStatus='';
    $paymentComments='';
    $orderID='';
    
    
    if(isset($_REQUEST['paymentMethod']))
    {
        $paymentMethod=$_REQUEST['paymentMethod'];
    }
    if(isset($_REQUEST['paymentStatus']))
    {
        $paymentStatus=$_REQUEST['paymentStatus'];
    }
    if(isset($_REQUEST['paymentComments']))
    {
        $paymentComments=$_REQUEST['paymentComments'];
    }
    if(isset($_REQUEST['orderID']))
    {
        $orderID=$_REQUEST['orderID'];
    }
    $order = wc_get_order($orderID);
    ?>
    <style>
        .title{
            text-align: center;
            font-size: 35px;
            margin: 20px 0 0;
            font-weight: 400;
        }
        .thankyou-order-received{
            text-align: center;
            font-size: 16px;
        }
        .order_details{
            padding: 35px 40px 2em;
            margin-bottom: 35px;
            max-width: 100%;
            margin-left: auto;
            margin-right: auto;
            border: 1px dashed #222;
        }
        .order_details li{
            float: left;
            width: 20%;
            font-weight: 500;
            font-size: 14px;
            text-transform: capitalize;
            border: 0;
            margin: 0;
            padding: 0;
            list-style: none;
        }
        .order_details li strong{
            text-transform: none;
            color: #000;
        }
        @media (max-width: 767px){
            .order_details{
                padding: 35px 40px 6em;
            }
            .order_details li{
                width: 100%;
            }
        }
    </style>
    <div class="container" style="max-width: 60%;margin: 0 auto;font-size:2.5em"><div class="row"><div style="width:100%"><br style="clear:both">
    <div class="thankyou-header">
        <?php if ($paymentStatus=='Completed' || $paymentStatus=='SUCCESS' || $paymentStatus=='APPROVED' || $paymentStatus=='COMPLETED' || strtolower($paymentStatus)=='succeeded'|| $paymentStatus=='SUCCESSFUL') : ?>
			<h1 class="title">Payment result: success!</h1>
			<p class="thankyou-order-received">Thank you. Your order has been received. However, the payment succeeded. Please check.</p>
		<?php else : ?>
		    <h1 class="title">Payment result: failure!</h1>
			<p class="thankyou-order-received">Thank you. Your order has been received. However, the payment failed. Please check.</p>
		<?php endif; ?>
		</div>
		<ul class="thankyou-order-details order_details">
			<li class="order">
				<?php esc_html_e( 'Order Number:' ); ?>
				<strong><?php echo trim($order->get_order_number()); ?></strong>
			</li>
			<li class="date">
				<?php esc_html_e( 'Date:' ); ?>
				<strong><?php echo wc_format_datetime( $order->get_date_created() ); ?></strong>
			</li>
			<?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() ) : ?>
				<li class="order-overview__email email">
					<?php esc_html_e( 'Email:' ); ?>
					<strong><?php echo trim($order->get_billing_email()); ?></strong>
				</li>
			<?php endif; ?>
			<li class="total">
				<?php esc_html_e( 'Total:' ); ?>
				<strong><?php echo trim($order->get_formatted_order_total()); ?></strong>
			</li>
			<?php if ( $order->get_payment_method_title() ) : ?>
			<li class="method">
				<?php esc_html_e( 'Payment Method:' ); ?>
				<strong><?php echo trim($order->get_payment_method_title()); ?></strong>
			</li>
			<?php endif; ?>
		</ul>
		<div class="clear"></div>
<?php
    if($orderID!='')
    {
    	if($paymentStatus=='Completed' || $paymentStatus=='SUCCESS' || $paymentStatus=='APPROVED' || $paymentStatus=='COMPLETED' || $paymentStatus=='succeeded'|| $paymentStatus=='SUCCESSFUL')
    	{
    	}
    	else
    	{
    		if(strstr($paymentComments,'Missing or invalid CardData data')){
    			echo "<h1>Incorrect credit card information, transaction failed, please resubmit.</h1><h2 class='mt-5'><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";
    		}else if(strstr($paymentComments,'Do not honor')||strstr($paymentComments,'Suspected fraud')||strstr($paymentComments,'Custom Fraud Screen Filter')){
    			echo "<h1>The card issuer considers the transaction to be risky and the card issuer rejects the transaction,so please change to another credit card and try again.</h1><h2 class='mt-5' ><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";
    		}else if(strstr($paymentComments,'challenge/authentication failed')){
    			echo "<h1>The card bank failed to process the transaction, and the 3DS verification failed,Please verify again.</h1><h2 class='mt-5' style='font-size:1.5em'><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";
    		}else if(strstr($paymentComments,'Restricted Card/Retain Card')){
    			echo "<h1>The card is marked as a restricted or lost card,please try again with a different credit card.</h1><h2 class='mt-5' style='font-size:1.5em'><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";
    		}else if(strstr($paymentComments,'Insufficient funds')){
    			echo "<h1>The card has insufficient balance,Please try again with a different credit card.</h1><h2 class='mt-5' style='font-size:1.5em'><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";
    		}else if(strstr($paymentComments,'declined by risk')){
    			echo "<h1>The card is rejected by risk control, please try another credit card.</h1><h2 class='mt-5' style='font-size:1.5em'><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";
    		}else if(strstr($paymentComments,'Card No. is incorrect')||strstr($paymentComments,'Invalid Card Number')){
    			echo "<h1>Invalid card number,please try another credit card.</h1><h2 class='mt-5'><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";
    		}else if(strstr($paymentComments,'Invalid CVV2')){
    			echo "<h1>CVV error,please resubmit.</h1><h2 class='mt-5'><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";
    		}else{
    			echo "<h1>Please check your credit card information and try again. Or use another credit card.</h1><h2 class='mt-5'>" . $paymentComments . "<br><a href='" . wc_get_checkout_url()  . "' style='color:blue'>Click here to view your order.</a></h2>";  
    		}
    	}
    }
    else
    {
    	echo "<script>location.href='" . site_url() . "';</script>";
    }
    echo '</div></div>';
    get_footer();
    if($paymentStatus=='Completed' || $paymentStatus=='SUCCESS' || $paymentStatus=='APPROVED' || $paymentStatus=='COMPLETED' || $paymentStatus=='succeeded'|| $paymentStatus=='SUCCESSFUL')
	{
		$thankyou_url = $order->get_checkout_order_received_url();
		echo "<script>location.href='" . $thankyou_url . "';</script>";
	}
    exit;
