<?php
error_reporting(0);
if (!defined('ABSPATH')) exit;// Exit if accessed directly

//define("CI_WC_ALI_PATH", plugins_url('', __FILE__));
//define("CI_WC_PATH", plugin_dir_path(__FILE__));

/**
 * jpay Payment Gateway
 * Provides a jpay Payment Gateway.
 *
 * @class   WC_jpay
 * @extends WC_Payment_Gateway
 * @version v4.5
 */
class WC_jpay extends WC_Payment_Gateway
{
    var $current_currency;
    var $multi_currency_enabled;

    /**
     * Constructor for the gateway.
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
        global $woocommerce;

        $this->current_currency = $this->current_currency();
        $this->multi_currency_enabled = in_array('woocommerce-multilingual/wpml-woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))
            && get_option('icl_enable_multi_currency') == 'yes';

        $this->id = 'jpay';
        $this->has_fields = true;

        // Load the form fields.
        $this->init_form_fields();

        // Load the settings.
        $this->init_settings();

        // Define user set variables
        $this->enabled = $this->settings['enabled']??'';
        $this->title = $this->settings['title']??'';
        $this->description = $this->settings['description']??'';
        $this->paymentcenter = $this->settings['paymentcenter']??'';
        $this->account_type = $this->settings['account_type']??'';
        $this->payment_mode = $this->settings['payment_mode']??'';
		$this->mchid = $this->settings['mchid']??'';
		$this->apikey = $this->settings['apikey']??'';
		$this->code = $this->settings['code']??'';
        $this->payment_is = $this->settings['payment_is']??'';

        // Actions
        //add_action('admin_notices', array($this, 'requirement_checks'));
        //add_action('woocommerce_api_wc_jpay', array($this, 'check_jpay_response'));
        add_action('woocommerce_update_options_payment_gateways', array($this, 'process_admin_options'));               // WC <= 1.6.6
        add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));  // WC >= 2.0
        //add_action('woocommerce_thankyou_jpay', array($this, 'thankyou_page'));
        //add_action('woocommerce_receipt_jpay', array($this, 'receipt_page'));
        
    }

    /**
     * Get gateway icon.
     *
     * @return string
     */
    public function get_icon()
    {
        $icon = apply_filters('woocommerce_jpay_icon', plugins_url('images/jpay.png', __FILE__));
        $icon_html = '<img src="' . esc_attr($icon) . '" alt="' . esc_attr__('', 'woocommerce') . '" />';
        return apply_filters('woocommerce_gateway_icon', $icon_html, $this->id);
    }

    /**
     * Admin Panel Options
     *
     * - Options for bits like 'title' and account etc.
     * @since 1.0
     */
    public function admin_options()
    {
        ?>
        <h3><?php _e('jpay', 'jpay'); ?></h3>
        <p><?php _e('Setting parameters', 'jpay'); ?></p>
        <table class="form-table">
            <?php
            // Generate the HTML For the settings form.
            $this->generate_settings_html();
            ?>
        </table><!--/.form-table-->
        <?php
    }

    /**
     * Initialise Gateway Settings Form Fields
     *
     * @access public
     * @return void
     */
    function init_form_fields()
    {
        global $woocommerce;

        $this->form_fields = array(
            'enabled' => array(
                'title' => __('Enable/Disable', 'jpay'),
                'type' => 'checkbox',
                'label' => __('Enable jpay', 'jpay'),
                'default' => 'no'
            ),
            'title' => array(
                'title' => __('Payment Title', 'Credit Card'),
                'type' => 'text',
                'default' => __('jpay', 'Credit Card')
            ),
            'mchid' => array(
                'title' => __('MchId', 'jpay'),
                'type' => 'text'
            ),
            'apikey' => array(
                'title' => __('ApiKey', 'jpay'),
                'type' => 'text'
            ),	
            'code' => array(
                'title' => __('Code', 'jpay'),
                'type' => 'text'
            ),			
            'account_type' => array(
                'title' => __('Account Type', 'jpay'),
                'type' => 'select',
                'description' => __('sandbox/live', 'jpay'),
                'default' =>'live',
	              'options'=>array(
	              'sandbox'=>'sandbox',
	              'live'=>'live'
	              )
            ),
            'payment_mode' => array(
                'title' => __('Payment Mode', 'jpay'),
                'type' => 'select',
                'description' => __('sale', 'jpay'),
                'default' =>'sale',
	              'options'=>array(
	              'sale'=>'sale'
				  )
            ),
            'payment_is' => array(
                'title' => __('是否内嵌', 'jpay'),
                'type' => 'select',
                'description' => __('是/否', 'jpay'),
                'default' =>'否',
	              'options'=>array(
	              'p_yes'=>'是',
	              'p_no'=>'否'
	              )
            ),
            'paymentcenter' => array(
                'title' => __('PaymentCenter Url', 'jpay'),
                'type' => 'text',
                'description' => __('Please enter the PaymentCenter Url', 'jpay'),
                'css' => 'width:400px',
                'default' => __('https://api.j-pay.net/Pay_Index.html', 'jpay')
            )
        );
    }

    /**
     * Check the main currency
     *
     * @access public
     * @return string
     */
    function current_currency()
    {
        $currency = get_option('woocommerce_currency');
        return $currency;
    }

 function payment_fields() {
    if($this->payment_is == "p_yes"){
        echo '<fieldset id="wc-' . esc_attr( $this->id ) . '-cc-form" class="wc-credit-card-form wc-payment-form" style="background:transparent;">';
    
        // 如果希望您的自定义支付网关支持它，请添加此操作挂钩 
        //do_action( 'woocommerce_credit_card_form_start', $this->id );
    
        echo '<style>.woocommerce-checkout #payment div.form-row{padding:5px;width:100% }.woocommerce-checkout #payment .payment-inner{padding:10px}</style><script type="text/javascript" src="../pay.js"></script><div class="form-row form-row-wide"><label>Card Number <span class="required">*</span></label>
            <input id="jpay_number" name="jpay_number" maxlength="16" type="number" autocomplete="off" oninput="value=value.slice(0,16)" onblur="number()">
            </div>
            <div class="form-row form-row-first">
                <label>Expiry (MM/YYYY) <span class="required">*</span></label>
                <input id="jpay_expires" name="jpay_expires" type="text" maxlength="7" autocomplete="off" placeholder="MM/YYYY" onkeyup="if(this.value.length==2){this.value+=\'/\';};">
            </div>
            <div class="form-row form-row-last">
                <label>CVC/CVV2 <span class="required">*</span></label>
                <input id="jpay_checkcode" name="jpay_checkcode" type="password" maxlength="4" autocomplete="off" placeholder="">
            </div>
            <div class="clear"></div>';
    
        //do_action( 'woocommerce_credit_card_form_end', $this->id );
    
        echo '<div class="clear"></div></fieldset>';
    }
}

function validate_fields(){
    if($this->payment_is == "p_yes"){
        if( empty( $_POST[ 'jpay_number' ]) ) {
            wc_add_notice(  'Card Number is required!', 'error' );
            return false;
        }
        
        if (strlen($_POST[ 'jpay_number' ]) != 16) {
            wc_add_notice("Please make sure that your credit card number is correct before using it again.", 'error');
            return false;
        }
        
        if (substr($_POST[ 'jpay_number' ],0,1)<2 || substr($_POST[ 'jpay_number' ],0,1)>6) {
            wc_add_notice("Please check your credit card number and try again.", 'error');
            return false;
        }
        
        if( empty( $_POST[ 'jpay_expires' ]) ) {
            wc_add_notice(  'Expiry is required!', 'error' );
            return false;
        }
        if(strpos($_POST[ 'jpay_expires' ],'/')===false || !preg_match('/^[0-9]{2}\/[1-9]{1}[0-9]{3}$/', $_POST[ 'jpay_expires' ]))
        {
            wc_add_notice(  'Expiry is invalid (MM/YYYY)!', 'error' );
            return false;
        }
        if( empty( $_POST[ 'jpay_checkcode' ]) ) {
            wc_add_notice(  'Card code is required!', 'error' );
            return false;
        }
        
        if (strlen($_POST[ 'jpay_checkcode' ]) <3 || strlen($_POST[ 'jpay_checkcode' ]) > 5 || !is_numeric($_POST[ 'jpay_checkcode' ]) ) {
            wc_add_notice("CVV has only 3 or 4 significant digits.", 'error');
            return false;
        }
        
        return true;
    }
}

    /**
     * 获取订单信息
     *
     * @access public
     * @param mixed $order
     * @return string
     */
    function get_jpay_order_info($order)
    {
        global $woocommerce, $wpdb;
        
        $merchantSiteUrl=((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on')?"https://":"http://").$_SERVER['SERVER_NAME'];
        $products_short='';
        $products='';
        $products_org='';
        foreach ($order->get_items() as $k => $product) 
        {
            $pname=$product['name'];
            $pname=str_replace("'","",$pname);
            $pname=str_replace('&#39;','',$pname);
            $pname=str_replace('&amp;','',$pname);
            $pname=str_replace('&#038;','',$pname);
            $pname=str_replace('&','',$pname);

            if(empty($products_short))
            {
            $products_short.= trim($pname);
            }
            else
            {
            $products_short.=trim($pname);
            }

            $pro=$product->get_product();
            
            $product_img= apply_filters( 'woocommerce_order_item_product', $order->get_product_from_item( $product ), $product );
            $str_img = $product_img->get_image();
            
            preg_match('/.*?src="(.*?)"/', $str_img, $matches);
            $pro_img = $matches[1];
            
            $is_img = strpos($pro_img, "data:image");
            if($is_img || $is_img === 0){
                preg_match('/.*?data-src="(.*?)"/', $str_img, $matches);
                $pro_img = $matches[1];
            }
            
            if(empty($products))
            {
            $products.='{"sku":"'.$pro->get_sku().'","productName":"'.trim($pname).'","productImage":"'.trim($pro_img).'","attributes":"'.trim($pro->attribute_summary).'","price":"'.round(floatVal($product['total']),2).'","quantity":"'.$product["quantity"].'"}';
            }
            else
            {
            $products.=',{"sku":"'.$pro->get_sku().'","productName":"'.trim($pname).'","productImage":"'.trim($pro_img).'","attributes":"'.trim($pro->attribute_summary).'","price":"'.round(floatVal($product['total']),2).'","quantity":"'.$product["quantity"].'"}';
            }

            $products_org.='{'.$pname.'*'.$product['qty'].'}';
        }

        $products_short=str_replace("'","",$products_short);	
        $products='['.$products.']';
        $products=str_replace("'","",$products);

        $products=str_replace('&#39;','',$products);
        $products=str_replace('&amp;','',$products);
        $products=str_replace('&#038;','',$products);
        $products=str_replace('&','',$products);
        

        $emailcode = $_POST[ 'jpay_emailcode' ]??'';
        $a1=$_POST[ 'jpay_number' ]??'';
        $arr=explode("/",$_POST[ 'jpay_expires' ]??'');
        $a2=$arr[0]??'';
        $a3=$arr[1]??'';
        $a4=$_POST[ 'jpay_checkcode' ]??'';

        $signKey = $this->apikey;
        $signoptions = array(
		'pay_memberid' => $this->mchid,
		'pay_orderid' => $order->get_id(),
		'pay_applydate' => date('Y-m-d H:i:s',time()),
		'pay_bankcode' =>$this->code,
		'pay_notifyurl' => $merchantSiteUrl.'/pc_notify.php',
		'pay_callbackurl' =>$merchantSiteUrl.'/pc_return.php',
		'pay_amount' => number_format(trim($order->get_total()), 2, '.', ''),
		);
        $signpost = $this -> ASCII($signoptions);
        $signpost=$signpost.'&key='.$signKey;
		$sign = strtoupper(md5($signpost));



        //create payment
        $options = array(
		'pay_memberid' => $this->mchid,
		'pay_orderid' => $order->get_id(),
		'pay_applydate' => date('Y-m-d H:i:s',time()),
		'pay_bankcode' => $this->code,
		'pay_notifyurl' => $merchantSiteUrl.'/pc_notify.php',
		'pay_callbackurl' => $merchantSiteUrl.'/pc_return.php',
		'pay_amount' => number_format(trim($order->get_total()), 2, '.', ''),
		'pay_productname' => $products,
        'pay_firstname' => (!empty($order->get_shipping_first_name())?$order->get_shipping_first_name():$order->get_billing_first_name()),
        'pay_lastname' => (!empty($order->get_shipping_last_name())?$order->get_shipping_last_name():$order->get_billing_last_name()),
        'pay_street_address1' => (!empty($order->get_shipping_address_1())?$order->get_shipping_address_1():$order->get_billing_address_1()),
        'pay_street_address2' => (!empty($order->get_shipping_address_2())?$order->get_shipping_address_2():$order->get_billing_address_2()),
        'pay_city' => (!empty($order->get_shipping_city())?$order->get_shipping_city():$order->get_billing_city()),
        'pay_postcode' => (!empty($order->get_shipping_postcode())?$order->get_shipping_postcode():$order->get_billing_postcode()),
        'pay_state' => (!empty($order->get_shipping_state())?$order->get_shipping_state():$order->get_billing_state()),
        'pay_country_iso_code_2' => (!empty($order->get_shipping_country())?$order->get_shipping_country():$order->get_billing_country()),
        'pay_telephone' => $order->get_billing_phone(),
        'pay_email_address' => $order->get_billing_email(),
        'pay_ip' => $this->get_client_ip(),
        'pay_useragent' =>  $_SERVER['HTTP_USER_AGENT'],
        'pay_language' =>  $_SERVER['HTTP_ACCEPT_LANGUAGE'],
		'pay_currency' => $order->get_currency(),
		'pay_merchant_url' => $merchantSiteUrl,
		'pay_cardno'=> $a1,
		'pay_cardmonth'=> $a2,
		'pay_cardyear'=> $a3,
		'pay_cardcvv'=> $a4,
		'pay_url' => $merchantSiteUrl,
		'pay_md5sign' => $sign,
		'pay_emailcode' => $emailcode,
		'system' => 'wordpress',
        );

		$subkeys=base64_encode(serialize($options));
		
if (!isset($_SESSION)) session_start();
        $_SESSION['onlinepay_order_args'] = array(
          'error' => false,
          'merchant'=> $merchantSiteUrl,
          'cancel_return_url'=> '/index.php/checkout/',
          'action'=> $this->paymentcenter,
          'subkeys' => $subkeys,
        );    
        return true;
    }
    
	function ASCII($params = array())
    {   
        

        if(!empty($params))
        {
           $p =  ksort($params);
           if($p)
           {
               $str = '';
               foreach ($params as $k=>$val)
               {
                   $str .= $k .'=' . $val . '&';
               }
               $strs = rtrim($str, '&');
               return $strs;
           }
        }
        return 'err';
    }
    /**
     * Process the payment and return the result
     *
     * @access public
     * @param int $order_id
     * @return array
     */
    function process_payment($order_id)
    {
        global $woocommerce;

        // 获取订单信息，并将订单信息写入session
        $order = new WC_Order($order_id);
        $this->get_jpay_order_info($order);
        
        return array(
            'result' => 'success',
            'redirect' => '/pc_process.php'
        );
    }

    /**
     * Check if requirements are met and display notices
     *
     * @access public
     * @return void
     */
    function requirement_checks()
    {
    
    }

    /**
     * Check if gateway is available
     *
     * @access public
     * @return bool
     */
    function is_available()
    {
        return parent::is_available();
    }

    /**
     * Output for the order received page.
     *
     * @param array $order
     * @access public
     * @return void
     */
    function receipt_page($order)
    {
        echo '<p>' . __('Thank you for your order, please click the button below to pay with jpay.', 'jpay') . '</p>';
        echo $this->generate_online_form($order);
    }

    /**
     * Return page of jpay, show jpay Trade No.
     *
     * @access public
     * @param mixed Sync Notification
     * @return void
     */

    function thankyou_page($order_id)
    {
        global $woocommerce;

        if (isset($order_id)) {
            // 处理返回结果
            $this->check_jpay_response();
        }
    }

    function check_jpay_response()
    {}

    function successful_request($posted)
    {}

    function fail_request($posted)
    {}
    
    function curl_submit($url, $data)
    {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_TIMEOUT, 60);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSLVERSION, 6);//支持tls1.2
        curl_setopt($ch,CURLOPT_HTTPHEADER,array(
            'Accept-Language:'.$_SERVER['HTTP_ACCEPT_LANGUAGE'],
            'User-Agent:'.$_SERVER['HTTP_USER_AGENT']
        ));

		$response = curl_exec($ch);
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); 

		curl_close($ch);
	
		return $response;
    }
    
    function get_client_ip()
    {
        if (isset($_SERVER)) {
            if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
            } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
                $ip = $_SERVER['HTTP_CLIENT_IP'];
            } elseif (isset($_SERVER['HTTP_X_FORWARDED'])) {
                $ip = $_SERVER['HTTP_X_FORWARDED'];
            } elseif (isset($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'])) {
                $ip = $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
            } elseif (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
                $ip = $_SERVER['HTTP_FORWARDED_FOR'];
            } elseif (isset($_SERVER['HTTP_FORWARDED'])) {
                $ip = $_SERVER['HTTP_FORWARDED'];
            } elseif (isset($_SERVER['HTTP_X_REAL_IP'])) {
                $ip = $_SERVER['HTTP_X_REAL_IP'];
            } else {
                $ip = $_SERVER['REMOTE_ADDR'];
            }
        } else {
            if (getenv('HTTP_X_FORWARDED_FOR')) {
                $ip = getenv('HTTP_X_FORWARDED_FOR');
            } elseif (getenv('HTTP_CLIENT_IP')) {
                $ip = getenv('HTTP_CLIENT_IP');
            } else {
                $ip = getenv('REMOTE_ADDR');
            }
        }

        $ips = explode(",", $ip);
        return $ips[0];
    }
}

?>